import numpy as np

# gradient of quadratic + log-sum-exp
def df1(x):
    term1 = x
    x_max = np.max(x, axis=1, keepdims=True)
    e = np.exp(x - x_max)
    term2 = e / e.sum(axis=1, keepdims=True)
    return term1 + term2


# gradient of quadractic + cosine
def df2(x, d):
    term1 = x
    term2 = 1 / (2 * d**0.25) * np.sin( d**0.25 * x )
    return term1 + term2

def LMC(config):
    h = config['step size']
    df = config['grad potential']
    n = config['num samples']
    d = config['dimension']
    ic = config['initial condition']
    n_iter = int(config['T'] / h)
    stats_fn = config['stats function']

    hist = np.zeros(n_iter + 1)

    x = np.zeros((n, d)) + ic
    hist[0] = stats_fn(x)

    for i in range(1, n_iter + 1):
        x -= h * df(x) + np.sqrt(2*h) * np.random.randn(n, d)
        hist[i] = stats_fn(x)
    
    return hist
